﻿
using System;
using System.Collections.Generic;
using System.Text;

namespace PI.ZB.N1200.ELearning.BL.DBD
{
    internal class Student_Competence : PI.FM.N000.Base.BL.DBD.BaseTable<BO.Student_Competence>
    {
        #region Static factory
        private static Student_Competence _factory = null;

        public static Student_Competence DBD
        {
            get
            {
                if (_factory == null)
                {
                    _factory = new Student_Competence();
                }
                return _factory;
            }
        }
        #endregion

        #region Override - Initialization
        protected override void InitializeTableName()
        {
            _tableName = "PIZB1200_Student_Competence";
        }

        protected override void InitializeProperties()
        {

            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("StudentID", "StudentID"));
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("CompetenceID", "CompetenceID"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("CompetencePointsByWeight", "CompetencePointsByWeight"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("CompetenceMaxPoints", "CompetenceMaxPoints"));
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("CompetenceEvaluationSheetID", "CompetenceEvaluationSheetID"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("CaseStudyPoints", "CaseStudyPoints"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("CaseStudyMaxPoints", "CaseStudyMaxPoints"));
            Add(new PI.FM.N000.Base.BL.DBD.DecimalProperty("Salary", "Salary"));
            Add(new PI.FM.N000.Base.BL.DBD.BoolProperty("IsStarted", "IsStarted"));
            Add(new PI.FM.N000.Base.BL.DBD.BoolProperty("IsEnded", "IsEnded"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("Flags", "Flags"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("ResetCount", "ResetCount"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("CompetencePartDone", "CompetencePartDone"));
        }
        #endregion


        #region Commands definition
        public enum Commands
        {
            RestoreBySearch = 10,
            CountBySearch = 11,
            RemoveBySearch = 12,
        }
        #endregion

        #region Get Commands
        protected override Gemini.Core.BL.Interface.DBD.ICommand DoGetCommand(int CommandID)
        {
            switch (CommandID)
            {
                case (int)Commands.RestoreBySearch: return new Command_RestoreBySearch();
                case (int)Commands.CountBySearch: return new Command_CountBySearch();
                case (int)Commands.RemoveBySearch: return new Command_RemoveBySearch();
            }

            return base.DoGetCommand(CommandID);
        }
        #endregion

        #region Additional Commands Classes
        class Command_RestoreBySearch : PI.FM.N000.Base.BL.DBD.BaseCommand<BO.Student_Competence>
        {
            public Command_RestoreBySearch() : base(PI.ZB.N1200.ELearning.BL.DBD.Student_Competence.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("StudentID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("CompetenceID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_Student_Competence_RestoreBySearch";
            }
        }
        class Command_CountBySearch : PI.FM.N000.Base.BL.DBD.BaseCommand<BO.Student_Competence>
        {
            public Command_CountBySearch() : base(PI.ZB.N1200.ELearning.BL.DBD.Student_Competence.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("StudentID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("CompetenceID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("Result", null, Gemini.Core.BL.DAL.SqlTypes.Int, System.Data.ParameterDirection.Output));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_Student_Competence_CountBySearch";
            }
        }
        class Command_RemoveBySearch : PI.FM.N000.Base.BL.DBD.BaseCommand<BO.Student_Competence>
        {
            public Command_RemoveBySearch() : base(PI.ZB.N1200.ELearning.BL.DBD.Student_Competence.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("StudentID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("CompetenceID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("EditDate", Gemini.Core.BL.DAL.SqlTypes.DateTime));
                Add(new Gemini.Core.BL.DBD.Param("EditUser", Gemini.Core.BL.DAL.SqlTypes.BigInt));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_Student_Competence_RemoveBySearch";
            }
        }
        #endregion
    }
}